document.addEventListener('DOMContentLoaded', function () {
	lucide.createIcons()

	const header = document.querySelector('.header')
	const menuToggle = document.querySelector('.menu-toggle')
	const connectWalletBtn = document.querySelector('.connect-wallet-btn')
	const coinPrice = document.querySelector('.coin-price')
	const priceChange = document.querySelector('.price-change')
	const priceIcon = document.querySelector('.price-icon')
	const tickerValues = document.querySelectorAll('.ticker-value')
	const dropdownToggle = document.querySelector('.dropdown-toggle')
	const dropdownMenu = document.querySelector('.dropdown-menu')

	let lastScroll = 0
	let currentPrice = 0.00156
	let volume24h = 2300000
	let marketCap = 15600000

	// Format large numbers
	function formatNumber(num) {
		if (num >= 1000000000) {
			return (num / 1000000000).toFixed(1) + 'B'
		} else if (num >= 1000000) {
			return (num / 1000000).toFixed(1) + 'M'
		} else if (num >= 1000) {
			return (num / 1000).toFixed(1) + 'K'
		}
		return num.toString()
	}

	// Fake price updates
	function updatePrice() {
		const change = (Math.random() - 0.5) * 0.0002
		currentPrice += change
		currentPrice = Math.max(0.0001, currentPrice)

		const percentChange = ((change / currentPrice) * 100).toFixed(2)
		const isPositive = change >= 0

		coinPrice.textContent = `$${currentPrice.toFixed(5)}`
		priceChange.textContent = `${isPositive ? '+' : ''}${percentChange}%`
		priceChange.className = `price-change ${
			isPositive ? 'positive' : 'negative'
		}`

		// Update icon
		priceIcon.setAttribute(
			'data-lucide',
			isPositive ? 'trending-up' : 'trending-down'
		)
		priceIcon.style.color = isPositive ? 'var(--accent-green)' : '#EF4444'
		lucide.createIcons()

		// Add pulse animation
		coinPrice.style.transform = 'scale(1.05)'
		setTimeout(() => {
			coinPrice.style.transform = 'scale(1)'
		}, 200)

		// Update volume and market cap
		volume24h += (Math.random() - 0.5) * 100000
		marketCap = currentPrice * 10000000000 // 10B supply

		if (tickerValues[0])
			tickerValues[0].textContent = `$${formatNumber(volume24h)}`
		if (tickerValues[1])
			tickerValues[1].textContent = `$${formatNumber(marketCap)}`
	}

	// Update price every 3-5 seconds
	// setInterval(updatePrice, Math.random() * 2000 + 3000) // Disabled - fixed price

	// Dropdown menu functionality
	dropdownToggle.addEventListener('click', function (e) {
		e.stopPropagation()
		this.classList.toggle('active')
		dropdownMenu.classList.toggle('active')
	})

	// Close dropdown when clicking outside
	document.addEventListener('click', function (e) {
		if (!e.target.closest('.dropdown-menu-container')) {
			dropdownToggle.classList.remove('active')
			dropdownMenu.classList.remove('active')
		}
	})

	// Close dropdown when clicking a link
	const dropdownLinks = document.querySelectorAll('.dropdown-link')
	dropdownLinks.forEach(link => {
		link.addEventListener('click', function () {
			dropdownToggle.classList.remove('active')
			dropdownMenu.classList.remove('active')
		})
	})

	window.addEventListener('scroll', function () {
		const currentScroll = window.pageYOffset

		if (currentScroll > 50) {
			header.classList.add('scrolled')
		} else {
			header.classList.remove('scrolled')
		}

		lastScroll = currentScroll
	})

	connectWalletBtn.addEventListener('click', async function () {
		const originalText = this.innerHTML

		this.innerHTML = `
            <i data-lucide="loader-2" class="icon animate-spin"></i>
            <span>Connecting...</span>
        `
		lucide.createIcons()

		setTimeout(() => {
			this.innerHTML = `
                <i data-lucide="check" class="icon"></i>
                <span>Connected</span>
            `
			lucide.createIcons()

			setTimeout(() => {
				this.innerHTML = originalText
				lucide.createIcons()
			}, 2000)
		}, 2000)
	})

	menuToggle.addEventListener('click', function () {
		this.classList.toggle('active')

		if (this.classList.contains('active')) {
			const mobileMenu = document.createElement('div')
			mobileMenu.className = 'mobile-menu'
			mobileMenu.innerHTML = `
                <nav class="mobile-nav">
                    <a href="#" class="mobile-nav-link">
                        <i data-lucide="info" class="icon"></i>
                        <span>About</span>
                    </a>
                    <a href="#" class="mobile-nav-link">
                        <i data-lucide="coins" class="icon"></i>
                        <span>Tokenomics</span>
                    </a>
                    <a href="#" class="mobile-nav-link">
                        <i data-lucide="map" class="icon"></i>
                        <span>Roadmap</span>
                    </a>
                    <a href="#" class="mobile-nav-link">
                        <i data-lucide="help-circle" class="icon"></i>
                        <span>FAQ</span>
                    </a>
                </nav>
            `

			document.body.appendChild(mobileMenu)
			document.body.style.overflow = 'hidden'

			setTimeout(() => {
				mobileMenu.classList.add('active')
				lucide.createIcons()
			}, 10)

			mobileMenu.addEventListener('click', function (e) {
				if (e.target.classList.contains('mobile-nav-link')) {
					menuToggle.classList.remove('active')
					mobileMenu.classList.remove('active')
					document.body.style.overflow = ''

					setTimeout(() => {
						mobileMenu.remove()
					}, 300)
				}
			})
		} else {
			const mobileMenu = document.querySelector('.mobile-menu')
			if (mobileMenu) {
				mobileMenu.classList.remove('active')
				document.body.style.overflow = ''

				setTimeout(() => {
					mobileMenu.remove()
				}, 300)
			}
		}
	})

	// Hero section interactions
	const heroPrimaryBtn = document.querySelector('.hero-btn-primary')
	const heroSecondaryBtn = document.querySelector('.hero-btn-secondary')

	if (heroPrimaryBtn) {
		heroPrimaryBtn.addEventListener('click', function () {
			console.log('Claim airdrop clicked')
			// Add your claim airdrop logic here
			const originalContent = this.innerHTML
			this.innerHTML = `
                <i data-lucide="loader-2" class="icon animate-spin"></i>
                <span>Processing...</span>
            `
			this.disabled = true
			lucide.createIcons()

			setTimeout(() => {
				this.innerHTML = `
                    <i data-lucide="check" class="icon"></i>
                    <span>Success!</span>
                `
				lucide.createIcons()

				setTimeout(() => {
					this.innerHTML = originalContent
					this.disabled = false
					lucide.createIcons()
				}, 2000)
			}, 2000)
		})
	}

	if (heroSecondaryBtn) {
		heroSecondaryBtn.addEventListener('click', function () {
			console.log('Learn more clicked')
			// Smooth scroll to next section
			const nextSection = document.querySelector('.hero').nextElementSibling
			if (nextSection) {
				nextSection.scrollIntoView({ behavior: 'smooth' })
			}
		})
	}

	// Parallax effect for floating elements
	const floatingElements = document.querySelectorAll('.floating-element')
	let ticking = false

	function updateParallax() {
		const scrolled = window.pageYOffset

		floatingElements.forEach((element, index) => {
			const speed = 0.5 + index * 0.2
			const yPos = -(scrolled * speed)
			const currentTransform = window
				.getComputedStyle(element)
				.transform.replace(/translateY\([^)]*\)/, '')
			element.style.transform = `${currentTransform} translateY(${yPos}px)`
		})

		ticking = false
	}

	function requestTick() {
		if (!ticking && floatingElements.length > 0) {
			window.requestAnimationFrame(updateParallax)
			ticking = true
		}
	}

	window.addEventListener('scroll', requestTick)

	// Number animation for stats
	const animateValue = (element, start, end, duration, suffix = '') => {
		let startTimestamp = null
		const step = timestamp => {
			if (!startTimestamp) startTimestamp = timestamp
			const progress = Math.min((timestamp - startTimestamp) / duration, 1)
			const value = Math.floor(progress * (end - start) + start)
			element.textContent = value.toLocaleString() + suffix
			if (progress < 1) {
				window.requestAnimationFrame(step)
			}
		}
		window.requestAnimationFrame(step)
	}

	// Intersection Observer for stats animation
	const statsObserver = new IntersectionObserver(
		entries => {
			entries.forEach(entry => {
				if (
					entry.isIntersecting &&
					!entry.target.classList.contains('animated')
				) {
					entry.target.classList.add('animated')
					const statValues = entry.target.querySelectorAll('.hero-stat-value')

					statValues.forEach(stat => {
						const text = stat.textContent
						if (text.includes('+')) {
							const num = parseInt(text.replace(/\D/g, ''))
							animateValue(stat, 0, num, 2000, '+')
						} else if (text.includes('%')) {
							const num = parseInt(text.replace(/\D/g, ''))
							animateValue(stat, 0, num, 1500, '%')
						} else if (text.includes('Days')) {
							animateValue(stat, 0, 5, 1000, ' Days')
						}
					})
				}
			})
		},
		{ threshold: 0.5 }
	)

	const heroStats = document.querySelector('.hero-stats')
	if (heroStats) {
		statsObserver.observe(heroStats)
	}

	// Add spin animation style
	const style = document.createElement('style')
	style.textContent = `
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .animate-spin {
            animation: spin 1s linear infinite;
        }
    `
	document.head.appendChild(style)

	// Tokenomics Interactive Functionality
	const initTokenomics = () => {
		const legendItems = document.querySelectorAll('.legend-item')
		const detailCards = document.querySelectorAll('.detail-card')
		const pieChart = document.querySelector('.pie-chart')

		// Color mapping for each category
		const colorMap = {
			airdrop: 'var(--accent-green)',
			liquidity: '#4ade80',
			development: '#22d3ee',
			marketing: '#fb7185',
		}

		// Function to set active card
		const setActiveCard = category => {
			// Remove active class from all cards
			detailCards.forEach(card => {
				card.classList.remove('active')
			})

			// Add active class to selected card
			const targetCard = document.querySelector(`[data-category="${category}"]`)
			if (targetCard && targetCard.classList.contains('detail-card')) {
				targetCard.classList.add('active')
			}

			// Update pie chart emphasis
			if (pieChart) {
				const gradients = {
					airdrop: `conic-gradient(
						from 0deg,
						var(--accent-green) 0deg 180deg,
						rgba(74, 222, 128, 0.6) 180deg 270deg,
						rgba(34, 211, 238, 0.6) 270deg 324deg,
						rgba(251, 113, 133, 0.6) 324deg 360deg
					)`,
					liquidity: `conic-gradient(
						from 0deg,
						rgba(131, 239, 170, 0.6) 0deg 180deg,
						#4ade80 180deg 270deg,
						rgba(34, 211, 238, 0.6) 270deg 324deg,
						rgba(251, 113, 133, 0.6) 324deg 360deg
					)`,
					development: `conic-gradient(
						from 0deg,
						rgba(131, 239, 170, 0.6) 0deg 180deg,
						rgba(74, 222, 128, 0.6) 180deg 270deg,
						#22d3ee 270deg 324deg,
						rgba(251, 113, 133, 0.6) 324deg 360deg
					)`,
					marketing: `conic-gradient(
						from 0deg,
						rgba(131, 239, 170, 0.6) 0deg 180deg,
						rgba(74, 222, 128, 0.6) 180deg 270deg,
						rgba(34, 211, 238, 0.6) 270deg 324deg,
						#fb7185 324deg 360deg
					)`,
				}
				pieChart.style.background = gradients[category] || gradients.airdrop
			}
		}

		// Add click handlers to legend items
		legendItems.forEach(item => {
			item.addEventListener('click', () => {
				const category = item.getAttribute('data-category')
				if (category) {
					setActiveCard(category)
				}
			})

			// Add hover effect
			item.addEventListener('mouseenter', () => {
				const category = item.getAttribute('data-category')
				if (category && colorMap[category]) {
					item.style.borderColor = colorMap[category]
				}
			})

			item.addEventListener('mouseleave', () => {
				item.style.borderColor = ''
			})
		})

		// Add click handlers to detail cards
		detailCards.forEach(card => {
			card.addEventListener('click', () => {
				const category = card.getAttribute('data-category')
				if (category) {
					setActiveCard(category)
				}
			})
		})

		// Initialize with airdrop as default
		setActiveCard('airdrop')
	}

	// Initialize tokenomics when section is in view
	const tokenomicsObserver = new IntersectionObserver(
		entries => {
			entries.forEach(entry => {
				if (
					entry.isIntersecting &&
					!entry.target.classList.contains('tokenomics-initialized')
				) {
					entry.target.classList.add('tokenomics-initialized')
					initTokenomics()
				}
			})
		},
		{ threshold: 0.3 }
	)

	const tokenomicsSection = document.querySelector('.tokenomics')
	if (tokenomicsSection) {
		tokenomicsObserver.observe(tokenomicsSection)
	}

	// Animate stats numbers in About section
	const aboutStatsObserver = new IntersectionObserver(
		entries => {
			entries.forEach(entry => {
				if (
					entry.isIntersecting &&
					!entry.target.classList.contains('stats-animated')
				) {
					entry.target.classList.add('stats-animated')
					const statNumbers = entry.target.querySelectorAll('.stat-number')

					statNumbers.forEach((stat, index) => {
						const text = stat.textContent
						let targetValue = 0
						let suffix = ''

						if (text.includes('M+')) {
							targetValue = parseFloat(text.replace('M+', ''))
							suffix = 'M+'
						} else if (text.includes('%')) {
							targetValue = parseInt(text.replace('%', ''))
							suffix = '%'
						} else {
							targetValue = parseInt(text.replace(/\D/g, ''))
							suffix = text.replace(/\d/g, '')
						}

						// Animate from 0 to target value
						let current = 0
						const increment = targetValue / 60 // 60 frames = ~1 second
						const timer = setInterval(() => {
							current += increment
							if (current >= targetValue) {
								current = targetValue
								clearInterval(timer)
							}

							if (suffix.includes('M')) {
								stat.textContent = current.toFixed(1) + suffix
							} else {
								stat.textContent = Math.floor(current) + suffix
							}
						}, 16) // ~60fps
					})
				}
			})
		},
		{ threshold: 0.5 }
	)

	const aboutStats = document.querySelector('.about-stats')
	if (aboutStats) {
		aboutStatsObserver.observe(aboutStats)
	}

	// Update mobile nav links to include anchors
	const updateMobileNavLinks = () => {
		const mobileNavLinks = document.querySelectorAll('.mobile-nav-link')
		mobileNavLinks.forEach(link => {
			const text = link.querySelector('span').textContent
			if (text === 'About') {
				link.href = '#about'
			} else if (text === 'Tokenomics') {
				link.href = '#tokenomics'
			}
		})
	}

	// Call updateMobileNavLinks when mobile menu is created
	const originalMenuToggleClick = menuToggle.addEventListener
	menuToggle.addEventListener('click', function () {
		setTimeout(updateMobileNavLinks, 50)
	})

	// FAQ Accordion Functionality
	const initFAQ = () => {
		const faqItems = document.querySelectorAll('.faq-item')
		const faqQuestions = document.querySelectorAll('.faq-question')

		faqQuestions.forEach(question => {
			question.addEventListener('click', function () {
				const faqItem = this.parentElement
				const faqAnswer = faqItem.querySelector('.faq-answer')
				const faqIcon = this.querySelector('.faq-icon')

				// Check if this item is currently active
				const isActive = faqItem.classList.contains('active')

				// Close all other FAQ items in the same category
				const currentCategory = faqItem.closest('.faq-category')
				const categoryItems = currentCategory.querySelectorAll('.faq-item')

				categoryItems.forEach(item => {
					if (item !== faqItem) {
						item.classList.remove('active')
					}
				})

				// Toggle current item
				if (isActive) {
					faqItem.classList.remove('active')
				} else {
					faqItem.classList.add('active')
				}

				// Re-create icons to apply new state
				lucide.createIcons()
			})

			// Add hover effects
			question.addEventListener('mouseenter', function () {
				const faqIcon = this.querySelector('.faq-icon')
				if (!this.parentElement.classList.contains('active')) {
					faqIcon.style.transform = 'scale(1.1) rotate(0deg)'
				}
			})

			question.addEventListener('mouseleave', function () {
				const faqIcon = this.querySelector('.faq-icon')
				if (!this.parentElement.classList.contains('active')) {
					faqIcon.style.transform = 'scale(1) rotate(0deg)'
				}
			})
		})

		// All FAQ items start closed by default

		lucide.createIcons()
	}

	// Initialize FAQ when section comes into view
	const faqObserver = new IntersectionObserver(
		entries => {
			entries.forEach(entry => {
				if (
					entry.isIntersecting &&
					!entry.target.classList.contains('faq-initialized')
				) {
					entry.target.classList.add('faq-initialized')
					initFAQ()
				}
			})
		},
		{ threshold: 0.2 }
	)

	const faqSection = document.querySelector('.faq')
	if (faqSection) {
		faqObserver.observe(faqSection)
	}

	// Update mobile navigation to include all sections
	const updateAllMobileNavLinks = () => {
		const mobileNavLinks = document.querySelectorAll('.mobile-nav-link')
		mobileNavLinks.forEach(link => {
			const text = link.querySelector('span').textContent
			if (text === 'About') {
				link.href = '#about'
			} else if (text === 'Tokenomics') {
				link.href = '#tokenomics'
			} else if (text === 'Roadmap') {
				link.href = '#roadmap'
			} else if (text === 'FAQ') {
				link.href = '#faq'
			}
		})
	}

	// Add smooth scrolling to all anchor links
	document.addEventListener('click', function (e) {
		if (e.target.matches('a[href^="#"]') || e.target.closest('a[href^="#"]')) {
			const link = e.target.matches('a[href^="#"]')
				? e.target
				: e.target.closest('a[href^="#"]')
			const targetId = link.getAttribute('href').substring(1)
			const targetElement = document.getElementById(targetId)

			if (targetElement) {
				e.preventDefault()
				targetElement.scrollIntoView({
					behavior: 'smooth',
					block: 'start',
				})
			}
		}
	})

	// Update the mobile menu creation to use the updated function
	menuToggle.addEventListener('click', function () {
		setTimeout(updateAllMobileNavLinks, 50)
	})
})
